@extends('layouts.master')
@section('title',__('Manual Rent'))
@section('breadcum')
<div class="breadcrumbbar">
    <h4 class="page-title">{{ __('Manual Rent') }}</h4>
    <div class="breadcrumb-list">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{url('/admin')}}"
                    title="{{ __('Dashboard') }}">{{ __('Dashboard') }}</a></li>
            <li class="breadcrumb-item active" aria-current="page">{{ __('Manual Rent') }}</li>
        </ol>
    </div>
</div>
@endsection
@section('maincontent')
<div class="contentbar">
    <div class="col-md-12 col-lg-12 col-xl-12">
        <div class="card">
            <div class="card-body">
                <div class="movie-series-btn mb-4">
                    <!-- Modal -->
                    <div class="modal fade" id="addMovieModal" tabindex="-1" aria-labelledby="exampleModalLabel"
                        aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLabel">Modal title</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form method="post" action="{{route('rent.store')}}">
                                        @csrf
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="customer" class="text-dark">{{ __('Select User') }}</label>
                                                <select class="form-control" id="customer" name="user_id">
                                                    <option value="">{{ __('Select User') }}</option>
                                                    @foreach($users as $user)
                                                    <option value="{{$user->id}}">{{$user->name}}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                            
                                                <div class="col-md-12">
                                                    <div class="form-group">
                                                        <label for="movie" class="text-dark">{{ __('Select Movie') }}</label>
                                                        <select class="form-control" id="movie" name="movie_id">
                                                            <option value="">{{ __('Select Movie') }}</option>
                                                            @foreach($movies as $movie)
                                                            <option value="{{$movie->id}}">{{$movie->title}}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                            </div>
                                            
                                            <div class="col-lg-12">
                                                <div class="form-group ">
                                                    <button type="reset" class="btn btn-success-rgba"
                                                        title="{{__('Reset')}}">{{__('Reset')}}</button>
                                                    <button type="submit" class="btn btn-primary-rgba"
                                                        title="{{ __('Update') }}"><i class="fa fa-check-circle"></i>
                                                        {{ __('Update') }}</button>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Modal -->
                    <div class="modal fade" id="addSeriesModal" tabindex="-1" aria-labelledby="exampleModalLabel"
                        aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exampleModalLabel">Modal title</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form method="post" action="{{route('tvrent.store')}}">
                                        @csrf
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="customer" class="text-dark">{{ __('Select User') }}</label>
                                                <select class="form-control" id="user" name="user_id">
                                                    <option value="">{{ __('Select User') }}</option>
                                                    @foreach($users as $user)
                                                    <option value="{{$user->id}}">{{$user->name}}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                                <div class="col-md-12">
                                                    <div class="form-group">
                                                        <label for="movie" class="text-dark">{{ __('Select Tv Series') }}</label>
                                                        <select class="form-control" id="movie" name="tv_series_id">
                                                            <option value="">{{ __('Select Tv Series') }}</option>
                                                            @foreach($tvseries as $data)
                                                            <option value="{{$data->id}}">{{$data->title}}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>
                                            
                                            <div class="col-lg-12">
                                                <div class="form-group ">
                                                    <button type="reset" class="btn btn-success-rgba"
                                                        title="{{__('Reset')}}">{{__('Reset')}}</button>
                                                    <button type="submit" class="btn btn-primary-rgba"
                                                        title="{{ __('Update') }}"><i class="fa fa-check-circle"></i>
                                                        {{ __('Update') }}</button>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th>{{__('Movie/Tv Series Name')}}</th>
                                        <th>{{__('User ID')}}</th>
                                        <th>{{__('Payment Method')}}</th>
                                        <th>{{__('Transaction ID')}}</th>
                                        <th>{{__('Price')}}</th>
                                        <th>{{__('Offer Price')}}</th>
                                        <th>{{__('Duration (Hours)')}}</th>
                                        <th>{{__('Expiry')}}</th>
                                        <th>{{__('Status')}}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($ppvPurchases as $purchase)
                                    <tr>
                                        <td>

                                            {{ $purchase->movie_title  }}{{ $purchase->tv_series_title  }}

                                        </td>
                                        <td>{{ $purchase->user_name }}</td>
                                        <td><span class="badge badge-primary"> {{$purchase->payment_type }}</span></td>
                                        <td>{{ $purchase->payment_id }}</td>
                                        <td>{{ $purchase->price }}</td>
                                        <td>{{ $purchase->offer_price }}</td>
                                        <td>{{ $purchase->hours }}</td>
                                        <td>
                                            @php
                                            $expiryTime = strtotime($purchase->expires_at);
                                            $currentTime = time();
                                            $remainingTime = $expiryTime - $currentTime;

                                            // Calculate hours if remaining time is positive
                                            $remainingHours = $remainingTime > 0 ? floor($remainingTime / 3600) : 0;

                                            // Format expiry date
                                            $formattedExpiryDate = date('Y-m-d H:i:s', $expiryTime);
                                            @endphp

                                            {{ $formattedExpiryDate }}<br>

                                            @if($remainingTime > 0)
                                            ({{ $remainingHours }} hours left)
                                            @endif
                                        </td>

                                        <td>
                                            @if($purchase->status == 1)
                                            <span class="badge badge-success">Active</span>
                                            @else
                                            <span class="badge badge-danger">Expired</span>
                                            @endif
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>

                            </table>
                        </div>
                    </div>
                </div>

            </div>

        </div>
    </div>
</div>
</div>
</div>
</div>
@endsection
@section('script')
@endsection